<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AllegroCategoryItemAdvertService
 *
 * @ORM\Table(name="allegro_category_item_advert_service")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\AllegroCategoryItemAdvertServiceRepository")
 */
class AllegroCategoryItemAdvertService
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="AllegroCategoryItem", mappedBy="advertService")
     */
    private $allegroCategoryItems;
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->allegroCategoryItems = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return AllegroCategoryItemAdvertService
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Add allegroCategoryItems
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems
     * @return AllegroCategoryItemAdvertService
     */
    public function addAllegroCategoryItem(\Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems)
    {
        $this->allegroCategoryItems[] = $allegroCategoryItems;
    
        return $this;
    }

    /**
     * Remove allegroCategoryItems
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems
     */
    public function removeAllegroCategoryItem(\Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems)
    {
        $this->allegroCategoryItems->removeElement($allegroCategoryItems);
    }

    /**
     * Get allegroCategoryItems
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getAllegroCategoryItems()
    {
        return $this->allegroCategoryItems;
    }
}

//INSERT INTO `allegro_category_item_advert_service`(`id`, `name`) VALUES
//(0,'oferta nie jest ogłoszeniowa'),
//(1,'otoMoto.pl'),
//(2,'otoDom.pl'),
//(3,'otoWakacje.pl'),
//(4,'AlleWakacje.pl'),
//(5,'Oferia.pl'),
//(6,'Tablica.pl'),
//(7,'ebooki.allegro.pl'),
//(10,'otoMoto.cz'),
//(11,'Hotel.cz'),
//(12,'Bezrealitky.cz'),
//(13,'Spa.cz'),
//(14,'Turistik.cz'),
//(15,'Wikireality.cz'),
//(16,'iDeveloper.cz')